package unitTest;

import com.google.common.collect.Lists;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import netsdk.callback.ACCEPT_REGISTER_CALLBACK;
import netsdk.callback.SUBSCRIBE_CALLBACK;
import netsdk.callback.impl.ACCEPT_REGISTER_CALLBACK_IMPL;
import netsdk.callback.impl.SUBSCRIBE_CALLBACK_IMPL;
import netsdk.lib.CommonFunctions;
import netsdk.lib.DeviceSdk;
import netsdk.struct.*;
import netsdk.struct.LPNET_SDK_DEVICEINFO.ByReference;

import org.apache.commons.lang3.StringUtils;
import org.junit.Test;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.UUID;

import javax.imageio.*;
import javax.imageio.stream.*;


public class NET_SDK_FaceMatchOperate_Test2 {

	/*public static void main(String[] args) {
		try {
			(new NET_SDK_FaceMatchOperate_Test2()).NET_SDK_SetRegisterCallback();
		} catch (Throwable e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}*/

    //@Test
//    public static List<NET_SDK_FACE_INFO_LIST_ITEM> NET_SDK_GET_FACE_INFO_LIST_Test() throws Throwable{
    public void NET_SDK_GET_FACE_INFO_LIST_Test() throws Throwable {
    	NET_SDK_FACE_INFO_ADD sfdkj = new NET_SDK_FACE_INFO_ADD();
    	System.out.println(sfdkj.size());
    	
        Boolean initResult = CommonFunctions.init();
        if (!initResult)
            return;
        LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
        NativeLong lUserID = CommonFunctions.login(lpDeviceInfo);

        List<NET_SDK_FACE_INFO_GROUP_ITEM> groupItems = NET_SDK_FaceMatchOperate_Test.NET_SDK_GET_FACE_INFO_GROUP_LIST_Run(lUserID);      

        if (groupItems.size() == 0) {
            System.out.println("没有特征组");
            return;
        }
        int groupId = groupItems.get(0).groupId;

        getFaceInfoList(lUserID, groupId, 1, 20);
        
		for(NET_SDK_FACE_INFO_GROUP_ITEM item : groupItems){
			Pointer p = item.getPointer();
			long peer = Pointer.nativeValue(p);
			Native.free(peer);// 手动释放内存
			Pointer.nativeValue(p, 0);	
		}		
    }

    public static List<NET_SDK_FACE_INFO_LIST_ITEM> getFaceInfoList(NativeLong lUserID, int groupId, int pageIndex, int pageSize) {
        NET_SDK_FACE_INFO_LIST_GET sIn = new NET_SDK_FACE_INFO_LIST_GET();
        sIn.groupId = groupId;
        sIn.pageIndex = 1;
        sIn.pageSize = 20;
        Memory lpInBuffer = new Memory(sIn.size());
        CommonFunctions.SetStructDataToPointer(sIn, lpInBuffer, 0);
        
        Memory lpOutBuffer = new Memory(20 * 1024);

        //Memory lpBytesReturned = new Memory(4);
        IntByReference lpBytesReturned = new IntByReference();
        boolean bResult = DeviceSdk.INSTANCE.NET_SDK_FaceMatchOperate(lUserID, 0x06, lpInBuffer,
                (int) lpInBuffer.size(), lpOutBuffer, (int) lpOutBuffer.size(), lpBytesReturned);
        if (!bResult) {
            throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
        }

        NET_SDK_FACE_INFO_LIST sOut = new NET_SDK_FACE_INFO_LIST();
        
        CommonFunctions.GetPointerDataToStruct(lpOutBuffer, 0, sOut);
        sOut.read();
        List<NET_SDK_FACE_INFO_LIST_ITEM> result = Lists.newArrayList();

        NET_SDK_FACE_INFO_LIST_ITEM[] items = new NET_SDK_FACE_INFO_LIST_ITEM[sOut.listNum];

        for (int i = 0; i < items.length; i++) {
            items[i] = new NET_SDK_FACE_INFO_LIST_ITEM();
        }
        CommonFunctions.GetPointerDataToStructArr(sOut.pFaceInfoListItem, items);

        for (NET_SDK_FACE_INFO_LIST_ITEM item : items) {
            try {
                System.out.println(String.format("人员列表==> itemId:%s, name:%s, certificateNum:%s, mobile:%s",
                        item.itemId,
                        new String(item.name, "UTF-8"),
                        new String(item.certificateNum),
                        new String(item.mobile)));
            } catch (Exception e) {
                e.printStackTrace();
            }
            result.add(item);
        }
        
        long peer1 = Pointer.nativeValue(lpInBuffer);  
        Native.free(peer1);//手动释放内存  
        Pointer.nativeValue(lpInBuffer, 0);
        
        long peer2 = Pointer.nativeValue(lpOutBuffer);  
        Native.free(peer2);//手动释放内存  
        Pointer.nativeValue(lpOutBuffer, 0);
        
//        long peer3 = Pointer.nativeValue(lpBytesReturned);  
//        Native.free(peer3);//手动释放内存  
//        Pointer.nativeValue(lpBytesReturned, 0);
        
        Pointer p = sOut.getPointer();
        long peer = Pointer.nativeValue(p);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(p, 0);
        
        return result;
    }

    @Test
    public void NET_SDK_ADD_FACE_INFO_Test() throws Throwable {

        Boolean initResult = CommonFunctions.init();
        if (!initResult)
            return;

        LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
        NativeLong lUserID = CommonFunctions.login(lpDeviceInfo);

//        NET_SDK_FACE_INFO_LIST_ITEM_GROUPS sInGroup = new NET_SDK_FACE_INFO_LIST_ITEM_GROUPS();
        
        List<NET_SDK_FACE_INFO_GROUP_ITEM> groupItems = NET_SDK_FaceMatchOperate_Test.NET_SDK_GET_FACE_INFO_GROUP_LIST_Run(lUserID);


        if (groupItems.size() == 0) {
            System.out.println("没有特征组");
            return;
        }
        String groupGuid = new String(groupItems.get(0).guid);
        int groupId = groupItems.get(0).groupId;

//        sInGroup.groupId = groupId;
//        System.arraycopy(groupGuid.getBytes(), 0, sInGroup.guid, 0, groupGuid.getBytes().length);
        //
        NET_SDK_FACE_INFO_LIST_ITEM sFaceInfoItem = new NET_SDK_FACE_INFO_LIST_ITEM();
        sFaceInfoItem.sex = 0;
        sFaceInfoItem.birthday = 20001231;
        sFaceInfoItem.certificateType = 0;
        sFaceInfoItem.faceImgCount = 1;
        
        File saveFile = new File("E:\\3.jpg");
        FileInputStream saveInputStream = new FileInputStream(saveFile);
        String name = "test";
        String city = "重庆";
        String mobile = "123456789";
        String number = "";
        String cardNumber = UUID.randomUUID().toString().replaceAll("-", "").substring(0, 20);
        long facePicSize = saveFile.length();
        try {
            System.arraycopy(name.getBytes("UTF-8"), 0, sFaceInfoItem.name, 0, name.getBytes("UTF-8").length);
            System.arraycopy(city.getBytes("UTF-8"), 0, sFaceInfoItem.nativePlace, 0, city.getBytes("UTF-8").length);
            //
            System.arraycopy(cardNumber.getBytes(), 0, sFaceInfoItem.certificateNum, 0, cardNumber.getBytes().length);
            System.arraycopy(mobile.getBytes(), 0, sFaceInfoItem.mobile, 0, mobile.getBytes().length);
            System.arraycopy(number.getBytes(), 0, sFaceInfoItem.number, 0, number.getBytes().length);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        sFaceInfoItem.groups[0].groupId = groupId;
        System.arraycopy(groupGuid.getBytes(), 0, sFaceInfoItem.groups[0].guid, 0, groupGuid.getBytes().length);
//        sFaceInfoItem.groups[0].groupId = sInGroup.groupId;
//        sFaceInfoItem.groups[0].guid = sInGroup.guid;
//        sFaceInfoItem.groups[0].validStartTime = sInGroup.validStartTime;
//        sFaceInfoItem.groups[0].validEndTime = sInGroup.validEndTime;
        
        //
        Memory imgData = new Memory(facePicSize);
        imgData.clear();
        if (!CommonFunctions.ReadToMemory(saveInputStream, facePicSize, imgData)) {
            throw new RuntimeException("read img file to memory failed!");
        }

        NET_SDK_FACE_INFO_ADD sIn = new NET_SDK_FACE_INFO_ADD();
        sIn.sFaceInfoItem = sFaceInfoItem;
        sIn.imgData = imgData;
//        sIn.imgHeight = 576;
//        sIn.imgWidth = 704;
        sIn.imgLen = (int) facePicSize;
        sIn.haveImgData = 1;
        sIn.imgNum = 1;
        //

        Memory lpInBuffer = new Memory(sIn.size());
        CommonFunctions.SetStructDataToPointer(sIn, lpInBuffer, 0);
//        System.out.println(sIn.sFaceInfoItem.size());
//        System.out.println(sIn.sFaceImgInfo[0].size());
//        System.out.println(sIn.sFaceInfoItem.groups[0].size());
//        System.out.println(sIn.sFaceInfoItem.groups[0].validStartTime.size());
        IntByReference lpBytesReturned = new IntByReference();
        //Memory lpBytesReturned = new Memory(4);
        boolean bResult = DeviceSdk.INSTANCE.NET_SDK_FaceMatchOperate(lUserID, 7, lpInBuffer, (int) lpInBuffer.size(), null, 0, lpBytesReturned);
        if (!bResult) {
            throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
        } else {
            System.out.println("增加目标成功");
        }
        
        Pointer p;
        long peer;
//        p = sInGroup.getPointer();
//        peer = Pointer.nativeValue(p);  
//        Native.free(peer);//手动释放内存  
//        Pointer.nativeValue(p, 0);

        for(NET_SDK_FACE_INFO_GROUP_ITEM item : groupItems){
			p = item.getPointer();
			peer = Pointer.nativeValue(p);
			Native.free(peer);// 手动释放内存
			Pointer.nativeValue(p, 0);	
		}
        
        p = sFaceInfoItem.getPointer();
        peer = Pointer.nativeValue(p);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(p, 0);

        peer = Pointer.nativeValue(imgData);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(imgData, 0);
        
        p = sIn.getPointer();
        peer = Pointer.nativeValue(p);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(p, 0);
        
        peer = Pointer.nativeValue(lpInBuffer);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(lpInBuffer, 0);
        
//        peer = Pointer.nativeValue(lpBytesReturned);  
//        Native.free(peer);//手动释放内存  
//        Pointer.nativeValue(lpBytesReturned, 0);
    }


    //@Test
    /**
     * 编辑目标
     *
     * @param lUserID
     * @param guid
     */
    public void NET_SDK_SET_FACE_INFO_Test() throws Throwable {

        Boolean initResult = CommonFunctions.init();
        if (!initResult)
            return;

        LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
        
        NativeLong lUserID = CommonFunctions.login(lpDeviceInfo);

        List<NET_SDK_FACE_INFO_GROUP_ITEM> groupItems = NET_SDK_FaceMatchOperate_Test.NET_SDK_GET_FACE_INFO_GROUP_LIST_Run(lUserID);

        if (groupItems.size() == 0) {
            System.out.println("没有特征组");
            return;
        }

        String groupGuid = new String(groupItems.get(0).guid);

        int groupId = groupItems.get(0).groupId;

        NET_SDK_FACE_INFO_LIST_ITEM_GROUPS sInGroup = new NET_SDK_FACE_INFO_LIST_ITEM_GROUPS();
        sInGroup.groupId = groupId;

        System.arraycopy(groupGuid.getBytes(), 0, sInGroup.guid, 0, groupGuid.getBytes().length);


        //
        List<NET_SDK_FACE_INFO_LIST_ITEM> memberItems = NET_SDK_FaceMatchOperate_Test2.getFaceInfoList(lUserID, groupId, 1, 20);

        if (memberItems.size() == 0) {
            System.out.println("没有目标");
            return;
        }

        NET_SDK_FACE_INFO_LIST_ITEM sFaceInfoItem = memberItems.get(0);
        sFaceInfoItem.sex = 0;
        sFaceInfoItem.birthday = 19980101;
        sFaceInfoItem.certificateType = 1;
        sFaceInfoItem.faceImgCount = 1;
        String name = "test";
        String city = "成都";
        boolean isDeleteImg = true;
        String mobile = "18988888888";
        String number = "V587";
        String cardNumber = UUID.randomUUID().toString().replaceAll("-", "").substring(0, 20);
        File modifyFile = new File("D:\\1.jpg");
        FileInputStream modifyInputStream = new FileInputStream(modifyFile);
        try {
            System.arraycopy(name.getBytes("UTF-8"), 0, sFaceInfoItem.name, 0, name.getBytes("UTF-8").length);
            System.arraycopy(city.getBytes("UTF-8"), 0, sFaceInfoItem.nativePlace, 0, city.getBytes("UTF-8").length);
            //
            System.arraycopy(cardNumber.getBytes(), 0, sFaceInfoItem.certificateNum, 0, cardNumber.getBytes().length);
            System.arraycopy(mobile.getBytes(), 0, sFaceInfoItem.mobile, 0, mobile.getBytes().length);
            System.arraycopy(number.getBytes(), 0, sFaceInfoItem.number, 0, number.getBytes().length);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        sFaceInfoItem.groups[0] = sInGroup;

        long facePicSize = modifyFile.length();
        Memory imgData = new Memory(facePicSize);
        imgData.clear();
        if (!CommonFunctions.ReadToMemory(modifyInputStream, facePicSize, imgData)) {
            throw new RuntimeException("read img file to memory failed!");
        }
        //
        NET_SDK_FACE_INFO_ADD sFaceInfoAdd = new NET_SDK_FACE_INFO_ADD();
        sFaceInfoAdd.sFaceInfoItem = sFaceInfoItem;
        sFaceInfoAdd.imgData = imgData;
        sFaceInfoAdd.imgLen = (int) facePicSize;
//        sFaceInfoAdd.imgHeight = 388;
//        sFaceInfoAdd.imgWidth = 508;
        sFaceInfoAdd.haveImgData = 1;
        sFaceInfoAdd.imgNum = 1;
        //
        NET_SDK_FACE_INFO_EDIT sIn = new NET_SDK_FACE_INFO_EDIT();
        sIn.sFaceInfoItem = sFaceInfoAdd;
        sIn.delFaceImgs[0] = isDeleteImg ? 1 : 0;

        Memory lpInBuffer = new Memory(sIn.size());
        CommonFunctions.SetStructDataToPointer(sIn, lpInBuffer, 0);
        //
        //Memory lpBytesReturned = new Memory(4);
        IntByReference lpBytesReturned = new IntByReference();
        boolean bResult = DeviceSdk.INSTANCE.NET_SDK_FaceMatchOperate(lUserID, 0x08, lpInBuffer, (int) lpInBuffer.size(), null, 0, lpBytesReturned);
        if (!bResult) {
            throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
        }
        System.out.println("编辑目标成功");
        
        Pointer p;
        long peer;
        p = lpDeviceInfo.getPointer();
        peer = Pointer.nativeValue(p);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(p, 0);
        
        for(NET_SDK_FACE_INFO_GROUP_ITEM item : groupItems){
			p = item.getPointer();
			peer = Pointer.nativeValue(p);
			Native.free(peer);// 手动释放内存
			Pointer.nativeValue(p, 0);	
		}
        
		p = sInGroup.getPointer();
        peer = Pointer.nativeValue(p);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(p, 0);
        
        p = sFaceInfoItem.getPointer();
        peer = Pointer.nativeValue(p);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(p, 0);
        
        peer = Pointer.nativeValue(imgData);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(imgData);
        
        p = sFaceInfoAdd.getPointer();
        peer = Pointer.nativeValue(p);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(p, 0);
        
        p = sIn.getPointer();
        peer = Pointer.nativeValue(p);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(p, 0);
        
        peer = Pointer.nativeValue(lpInBuffer);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(lpInBuffer);
        
//        peer = Pointer.nativeValue(lpBytesReturned);  
//        Native.free(peer);//手动释放内存  
//        Pointer.nativeValue(lpBytesReturned); 
    }

    //@Test
    /**
     * 删除目标
     *
     * @param lUserID
     * @param guid
     */
    public void NET_SDK_DEL_FACE_INFO_Test() throws Throwable {
        Boolean initResult = CommonFunctions.init();
        if (!initResult)
            return;

        LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
        NativeLong lUserID = CommonFunctions.login(lpDeviceInfo);

        List<NET_SDK_FACE_INFO_GROUP_ITEM> groupItems = NET_SDK_FaceMatchOperate_Test.NET_SDK_GET_FACE_INFO_GROUP_LIST_Run(lUserID);

        if (groupItems.size() == 0) {
            System.out.println("没有特征组");
            return;
        }
        int groupId = groupItems.get(0).groupId;
        List<NET_SDK_FACE_INFO_LIST_ITEM> memberItems = NET_SDK_FaceMatchOperate_Test2.getFaceInfoList(lUserID, groupId, 1, 20);

        if (memberItems.size() == 0) {
            System.out.println("没有目标");
            return;
        }


        NET_SDK_FACE_INFO_DEL sIn = new NET_SDK_FACE_INFO_DEL();
        sIn.groupsId[0] = groupId;
        sIn.faceInfoListItemId = memberItems.get(0).itemId;
        Memory lpInBuffer = new Memory(sIn.size());
        CommonFunctions.SetStructDataToPointer(sIn, lpInBuffer, 0);
        IntByReference lpBytesReturned = new IntByReference();
        //Memory lpBytesReturned = new Memory(4);
        boolean bResult = DeviceSdk.INSTANCE.NET_SDK_FaceMatchOperate(lUserID, 0x09, lpInBuffer,
                (int) lpInBuffer.size(), null, 0, lpBytesReturned);
        if (!bResult) {
            throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
        }
        
        //释放内存
        Pointer p;
        long peer;
        p = lpDeviceInfo.getPointer();
        peer = Pointer.nativeValue(p);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(p, 0);
        
        for(NET_SDK_FACE_INFO_GROUP_ITEM item : groupItems){
			p = item.getPointer();
			peer = Pointer.nativeValue(p);
			Native.free(peer);// 手动释放内存
			Pointer.nativeValue(p, 0);	
		}
        
        p = sIn.getPointer();
        peer = Pointer.nativeValue(p);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(p, 0);
        
        peer = Pointer.nativeValue(lpInBuffer);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(lpInBuffer);
        
//        peer = Pointer.nativeValue(lpBytesReturned);  
//        Native.free(peer);//手动释放内存  
//        Pointer.nativeValue(lpBytesReturned); 
    }

    //@Test
    public void setSDKMessageCallBack() throws Throwable {
        System.out.println("*********************智能事件回调函数******************************");
//        SUBSCRIBE_CALLBACK subscribe = new SUBSCRIBE_CALLBACK_IMPL();
//        DeviceSdk.INSTANCE.NET_SDK_SetSubscribCallBack(subscribe, null);
        
        Boolean initResult = CommonFunctions.init();
        if (!initResult)
            return;

        LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
        CommonFunctions.login(lpDeviceInfo);
        
        // TODO 设置智能分析事件上报回调
        DeviceSdk.INSTANCE.NET_SDK_SetSubscribCallBack(new SUBSCRIBE_CALLBACK() {
            @Override
            public void invoke(NativeLong lUserID, int dwCommand, Pointer pBuf, int dwBufLen, Pointer pUser) {
                System.out.println(String.format("智能分析==> lUserID:%s, dwCommand:%s, pBuf:%s, dwBufLen:%s", lUserID, dwCommand, pBuf, dwBufLen));
                switch (dwCommand) {
                    case 16:// 人脸比对
                    {
                        NET_SDK_IVE_FACE_MATCH_T faceMatchT = new NET_SDK_IVE_FACE_MATCH_T();
                        CommonFunctions.GetPointerDataToStruct(pBuf, 0, faceMatchT);
                        faceMatchT.read();
                        try {
                            System.out.println(String.format("人脸比对==> 姓名：%s, 相似度:%s", StringUtils.trim(new String(faceMatchT.byName, "UTF-8")), faceMatchT.dwSimilar));
                        } catch (UnsupportedEncodingException e) {
                        }
                        
                        Pointer p = faceMatchT.getPointer();
                        long peer = Pointer.nativeValue(p);  
                        Native.free(peer);//手动释放内存  
                        Pointer.nativeValue(p, 0);
                    }
                    break;
                    default:
                        break;
                }
            }
        }, null);

        Scanner s = new Scanner(System.in);
        while (s.hasNext()){
            if(s.next().equals("q")){
                break;
            }
        }

    }

    /**
     * 保存图片
     *
     * @param userId
     * @param data
     * @return 相对路径
     * @throws Throwable
     * @throws Exception
     */
    /*private String genImg(String userId, byte[] data, String type) throws Exception {
        ImgService imgService = SpringContextUtil.getBean(ImgService.class);
        Map<String, String> dirMap = imgService.getPhotoPath(userId);
        String filePath = dirMap.get("filePath");// 相对路径
        String dirStr = dirMap.get("dirStr");// 绝对路径
        String photoName = imgService.getPhotoName();
        String photoPath = filePath + photoName;
        imgService.byte2Img(data, dirStr, photoName);
        log.info("{} filepath:{}", type, new File(dirStr + photoName).getAbsolutePath());
        return photoPath;
    }*/
    //@Test
    public void NET_SDK_SEARCH_CH_SNAP_FACE_IMG_LIST_Test() throws Throwable {
        NET_SDK_SEARCH_CH_SNAP_FACE_IMG_LIST();
    }


    public static List<NET_SDK_FACE_IMG_INFO_CH> NET_SDK_SEARCH_CH_SNAP_FACE_IMG_LIST() throws Throwable {
        Boolean initResult = CommonFunctions.init();
        if (!initResult)
            return null;
        LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
        NativeLong lUserID = CommonFunctions.login(lpDeviceInfo);

        NET_SDK_CH_SNAP_FACE_IMG_LIST_SEARCH sIn = new NET_SDK_CH_SNAP_FACE_IMG_LIST_SEARCH();
        DD_TIME lpStartTime = new DD_TIME();
        lpStartTime.year = 2018;//2018年
        lpStartTime.month = 7;//5月
        lpStartTime.mday = 18;//9日
        lpStartTime.hour = 00;//时
        lpStartTime.minute = 00;//分
        lpStartTime.second = 00;//秒

        DD_TIME lpEndTime = new DD_TIME();
        lpEndTime.year = 2018;//2018年
        lpEndTime.month = 7;//5月
        lpEndTime.mday = 18;//9日
        lpEndTime.hour = 23;//时
        lpEndTime.minute = 59;//分
        lpEndTime.second = 59;//秒

        sIn.dwChannel = 1;
        sIn.startTime = lpStartTime;
        sIn.endTime = lpEndTime;
        sIn.pageIndex = 1;
        sIn.pageSize = 20;

        Memory lpInBuffer = new Memory(sIn.size());
        CommonFunctions.SetStructDataToPointer(sIn, lpInBuffer, 0);

        Memory lpOutBuffer = new Memory(20 * 1024);
        //Memory lpBytesReturned = new Memory(4);
        IntByReference lpBytesReturned = new IntByReference();
        boolean bResult = DeviceSdk.INSTANCE.NET_SDK_FaceMatchOperate(lUserID, 0x0E, lpInBuffer,
                (int) lpInBuffer.size(), lpOutBuffer, (int) lpOutBuffer.size(), lpBytesReturned);
        if (!bResult) {
            throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
        }

        NET_SDK_CH_SNAP_FACE_IMG_LIST oSH = new NET_SDK_CH_SNAP_FACE_IMG_LIST();
        int index = 0;
        oSH.bEnd = lpOutBuffer.getInt(index);
        System.out.println("bEnd:" + oSH.bEnd);
        index += 4;
        oSH.listNum = lpOutBuffer.getInt(index);
        System.out.println("listNum:" + oSH.listNum);
        index += 4;

        List<NET_SDK_FACE_IMG_INFO_CH> result = Lists.newArrayList();

        NET_SDK_FACE_IMG_INFO_CH[] arrImgInfo = new NET_SDK_FACE_IMG_INFO_CH[oSH.listNum];
        for (int i = 0; i < oSH.listNum; i++) {
            arrImgInfo[i] = new NET_SDK_FACE_IMG_INFO_CH();
        }
        index += 8;
        CommonFunctions.GetPointerDataToStructArr(lpOutBuffer, index, arrImgInfo);
        for (int i = 0; i < arrImgInfo.length; i++) {
            System.out.println(String.format(i + " item -- imgId:%s,  chl:%s", arrImgInfo[i].snapImgId, arrImgInfo[i].chl));
            result.add(arrImgInfo[i]);
        }
        
        Pointer p;
        long peer;
        p = lpDeviceInfo.getPointer();
        peer = Pointer.nativeValue(p);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(p, 0);
        
        p = oSH.getPointer();
        peer = Pointer.nativeValue(p);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(p, 0);
        
        p = sIn.getPointer();
        peer = Pointer.nativeValue(p);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(p, 0);
        
        peer = Pointer.nativeValue(lpInBuffer);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(lpInBuffer);
        
        peer = Pointer.nativeValue(lpOutBuffer);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(lpOutBuffer);
        
//        peer = Pointer.nativeValue(lpBytesReturned);  
//        Native.free(peer);//手动释放内存  
//        Pointer.nativeValue(lpBytesReturned);

        return result;
    }

   // @Test
    public void NET_SDK_SEARCH_CH_SNAP_FACE_IMG_Test() throws Throwable {
        Boolean initResult = CommonFunctions.init();
        if (!initResult)
            return;
        LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
        NativeLong lUserID = CommonFunctions.login(lpDeviceInfo);

        System.out.println("*********************NET_SDK_SEARCH_CH_SNAP_FACE_IMG******************************");
        NET_SDK_FACE_IMG_INFO_CH sIn = new NET_SDK_FACE_IMG_INFO_CH();

        List<NET_SDK_FACE_IMG_INFO_CH> Item = NET_SDK_SEARCH_CH_SNAP_FACE_IMG_LIST();
        NET_SDK_FACE_IMG_INFO_CH sFaceImgInfoCh = Item.get(0);

        sIn.frameTime = sFaceImgInfoCh.frameTime;

        sIn.snapImgId = sFaceImgInfoCh.snapImgId;
        sIn.chl = sFaceImgInfoCh.chl;
        Memory lpInBuffer = new Memory(sIn.size());
        CommonFunctions.SetStructDataToPointer(sIn, lpInBuffer, 0);

        Memory lpOutBuffer = new Memory(20 * 1024);
        //Memory lpBytesReturned = new Memory(4);
        IntByReference lpBytesReturned = new IntByReference();
        boolean bResult = DeviceSdk.INSTANCE.NET_SDK_FaceMatchOperate(lUserID, 0x0F, lpInBuffer,
                (int) lpInBuffer.size(), lpOutBuffer, (int) lpOutBuffer.size(), lpBytesReturned);
        if (!bResult) {
            throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
        }

        NET_SDK_FACE_INFO_IMG_DATA sOut = new NET_SDK_FACE_INFO_IMG_DATA();
        sOut.imgLen = lpOutBuffer.getInt(0);
        System.out.println("imgLen:" + sOut.imgLen);
        
        Pointer p;
        long peer;
        p = lpDeviceInfo.getPointer();
        peer = Pointer.nativeValue(p);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(p, 0);
        
        p = sIn.getPointer();
        peer = Pointer.nativeValue(p);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(p, 0);
        
        p = sOut.getPointer();
        peer = Pointer.nativeValue(p);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(p, 0);
        
        
        peer = Pointer.nativeValue(lpInBuffer);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(lpInBuffer);
        
        peer = Pointer.nativeValue(lpOutBuffer);  
        Native.free(peer);//手动释放内存  
        Pointer.nativeValue(lpOutBuffer);
        
//        peer = Pointer.nativeValue(lpBytesReturned);  
//        Native.free(peer);//手动释放内存  
//        Pointer.nativeValue(lpBytesReturned);
    }

    
    public static void NET_SDK_SetRegisterPort() throws Throwable{
    	
         System.out.println("*********************SDK被动接收DVR注册 的本地端口号******************************");
 		 boolean result = DeviceSdk.INSTANCE.NET_SDK_SetRegisterPort(2009,null,0);
 		 System.out.println("SDK被动接收DVR注册 的本地端口号: " + result);
    }
    
    //@Test
    public void NET_SDK_SetRegisterCallback() throws Throwable{
    	Boolean initResult = CommonFunctions.init();
        if (!initResult)
            return;

        NET_SDK_SetRegisterPort();
        
//        LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
//        CommonFunctions.login(lpDeviceInfo);
        
        System.out.println("*********************SDK被动接收DVR注册 的本地端口号  回调******************************");
//		ACCEPT_REGISTER_CALLBACK fRegisterCBFun = new ACCEPT_REGISTER_CALLBACK_IMPL();
		boolean result = DeviceSdk.INSTANCE.NET_SDK_SetRegisterCallback(new ACCEPT_REGISTER_CALLBACK_IMPL(){
			public void invoke(NativeLong lUserID, NativeLong lRegisterID, ByReference pDeviceInfo, Pointer pUser) {
				System.out.println("ACCEPT_REGISTER_CALLBACK_IMPL  回调方法执行");
			}
		}, null);
		
//		boolean result = DeviceSdk.INSTANCE.NET_SDK_SetRegisterCallback(fRegisterCBFun, null);
		
		System.out.println(result);
		
//		NET_SDK_SetRegisterPort();
		
		Scanner s = new Scanner(System.in);
        while (s.hasNext()){
            if(s.next().equals("q")){
                break;
            }
        }
		
    }
}
